<?php

// Shop Archive settings
function ecosoap_woo_redux_config($sections, $sidebars, $columns) {
    $attributes = array();
    if ( is_admin() ) {
        $attrs = wc_get_attribute_taxonomies();
        if ( $attrs ) {
            foreach ( $attrs as $tax ) {
                $attributes[wc_attribute_taxonomy_name( $tax->attribute_name )] = $tax->attribute_label;
            }
        }
    }
    $sections[] = array(
        'icon' => 'el el-shopping-cart',
        'title' => esc_html__('Shop Settings', 'ecosoap'),
        'fields' => array(
            array(
                'id' => 'products_general_total_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'enable_shop_catalog',
                'type' => 'switch',
                'title' => esc_html__('Enable Shop Catalog', 'ecosoap'),
                'default' => 0,
                'subtitle' => esc_html__('Enable Catalog Mode for disable Add To Cart button, Cart, Checkout', 'ecosoap'),
            ),
            // array(
            //     'id' => 'colection_gutter',
            //     'type' => 'switch',
            //     'title' => esc_html__('Show Colection Gutter', 'ecosoap'),
            //     'default' => 0
            // ),
            array(
                'id' => 'products_watches_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Swatches Variation Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'show_product_swatches_on_grid',
                'type' => 'switch',
                'title' => esc_html__('Show Swatches On Product Grid', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'product_swatches_attribute',
                'type' => 'select',
                'title' => esc_html__( 'Grid swatch attribute to display', 'ecosoap' ),
                'subtitle' => esc_html__( 'Choose attribute that will be shown on products grid', 'ecosoap' ),
                'options' => $attributes
            ),
            array(
                'id' => 'show_product_swatches_use_images',
                'type' => 'switch',
                'title' => esc_html__('Use images from product variations', 'ecosoap'),
                'subtitle' => esc_html__( 'If enabled swatches buttons will be filled with images choosed for product variations and not with images uploaded to attribute terms.', 'ecosoap' ),
                'default' => 1
            ),
            array(
                'id' => 'products_breadcrumb_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Breadcrumbs Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'show_product_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'ecosoap'),
                'default' => 1
            ),
            array(
                'title' => esc_html__('Breadcrumbs Background Color', 'ecosoap'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'ecosoap').'</em>',
                'id' => 'woo_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'woo_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'ecosoap'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'ecosoap'),
            ),
        )
    );
    // Archive settings
    $elementor_options = ['' => esc_html__('Choose a Elementor Template', 'ecosoap')];
    if ( did_action( 'elementor/loaded' ) && is_admin() && !empty($_GET['page']) && $_GET['page'] == '_options' ) {
        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();
        
        if ( !empty( $templates ) ) {
            foreach ( $templates as $template ) {
                $elementor_options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
    }
    $sections[] = array(
        'title' => esc_html__('Product Archives', 'ecosoap'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'products_top_section_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Top Shop Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'shop_elementor_template',
                'type' => 'select',
                'title' => esc_html__('Top Content (Elementor Template)', 'ecosoap'),
                'subtitle' => esc_html__('Choose a Elementor Template to show in top.', 'ecosoap'),
                'options' => $elementor_options,
                'default' => '',
            ),
            array(
                'id' => 'products_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'ecosoap').'</h3>',
            ),
           
            
            array(
                'id' => 'product_columns',
                'type' => 'select',
                'title' => esc_html__('Product Columns', 'ecosoap'),
                'options' => $columns,
                'default' => 4,
            ),
            // array(
            //     'id' => 'product_item_style',
            //     'type' => 'select',
            //     'title' => esc_html__('Product Style', 'ecosoap'),
            //     'options' => array(
            //         'v1' => esc_html__('Style 1', 'ecosoap'),
            //         'v2' => esc_html__('Style 2', 'ecosoap'),
            //         'v3' => esc_html__('Style 3', 'ecosoap'),
            //     ),
            //     'default' => 'v1',
            //     // 'required' => array('product_display_mode', '=', array('grid'))
            // ),

            array(
                'id' => 'number_products_per_page',
                'type' => 'text',
                'title' => esc_html__('Number of Products Per Page', 'ecosoap'),
                'default' => 12,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            
            array(
                'id' => 'show_quickview',
                'type' => 'switch',
                'title' => esc_html__('Show Quick View', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'enable_swap_image',
                'type' => 'switch',
                'title' => esc_html__('Enable Swap Image', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'product_pagination',
                'type' => 'select',
                'title' => esc_html__('Pagination Type', 'ecosoap'),
                'options' => array(
                    'default' => esc_html__('Default', 'ecosoap'),
                    'loadmore' => esc_html__('Load More Button', 'ecosoap'),
                    'infinite' => esc_html__('Infinite Scrolling', 'ecosoap'),
                ),
                'default' => 'default'
            ),

            array(
                'id' => 'products_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Sidebar Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'product_archive_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'ecosoap'),
                'default' => false
            ),
            array(
                'id' => 'product_archive_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Archive Product Layout', 'ecosoap'),
                'subtitle' => esc_html__('Select the layout you want to apply on your archive product page.', 'ecosoap'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'ecosoap'),
                        'alt' => esc_html__('Main Content', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left Sidebar - Main Content', 'ecosoap'),
                        'alt' => esc_html__('Left Sidebar - Main Content', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main Content - Right Sidebar', 'ecosoap'),
                        'alt' => esc_html__('Main Content - Right Sidebar', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'left-main'
            ),
            array(
                'id' => 'product_archive_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'ecosoap'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'ecosoap'),
                'options' => $sidebars,
                'required' => array('product_archive_layout', '=', array('left-main'))
            ),
            array(
                'id' => 'product_archive_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'ecosoap'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'ecosoap'),
                'options' => $sidebars,
                'required' => array('product_archive_layout', '=', array('main-right'))
            ),
            array(
                'id' => 'product_archive_top_filter_style',
                'type' => 'select',
                'title' => esc_html__('Top Filter Style', 'ecosoap'),
                'subtitle' => esc_html__('Choose a top filter style.', 'ecosoap'),
                'options' => array(
                    'style1' => esc_html__('Style 1', 'ecosoap'),
                    'style2' => esc_html__('Style 2', 'ecosoap'),
                ),
                'default' => 'style1',
                'required' => array('product_archive_layout', '=', array('main'))
            ),
        )
    );
    
    
    // Product Page
    $sections[] = array(
        'title' => esc_html__('Single Product', 'ecosoap'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'product_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'product_header_type',
                'type' => 'select',
                'title' => esc_html__('Header Layout Type (Product Details)', 'ecosoap'),
                'subtitle' => esc_html__('Choose a header for your website.', 'ecosoap'),
                'options' => array_merge( array('global' => esc_html__( 'Global Setting', 'ecosoap' )), ecosoap_get_header_layouts() ),
                'desc' => sprintf(wp_kses(__('You can add or edit a header in <a href="%s" target="_blank">Headers Builder</a>', 'ecosoap'), array( 'a' => array('href' => array(), 'target' => array()) )), esc_url( admin_url( 'edit.php?post_type=goal_megamenu') )),
            ),
            array(
                'id' => 'product_single_version',
                'type' => 'select',
                'title' => esc_html__('Product Layout', 'ecosoap'),
                'options' => array(
                    'v1' => esc_html__('Layout 1', 'ecosoap'),
                    'v2' => esc_html__('Layout 2', 'ecosoap'),
                    'v3' => esc_html__('Layout 3', 'ecosoap'),
                    'v4' => esc_html__('Layout 4', 'ecosoap'),
                    'v5' => esc_html__('Layout 5', 'ecosoap'),
                    'v6' => esc_html__('Layout 6', 'ecosoap'),
                    'v7' => esc_html__('Layout 7', 'ecosoap'),
                ),
                'default' => 'v1',
            ),
            array(
                'title' => esc_html__('Background Color', 'ecosoap'),
                'subtitle' => '<em>'.esc_html__('The background color header.', 'ecosoap').'</em>',
                'id' => 'product_bg_color',
                'type' => 'color',
                'transparent' => false,
                'required' => array('product_single_version', '=', array('v2', 'v3'))
            ),
            array(
                'id' => 'enable_sticky_cart',
                'type' => 'switch',
                'title' => esc_html__('Enable Top Sticky Cart', 'ecosoap'),
                'default' => 1,
                'required' => array('product_single_version', '=', array('v4', 'v5'))
            ),
            array(
                'id' => 'product_delivery_title',
                'type' => 'text',
                'title' => esc_html__('Delivery Title', 'ecosoap'),
                'default' => 'Delivery and return',
            ),
            array(
                'id' => 'product_delivery_info',
                'type' => 'editor',
                'title' => esc_html__('Delivery Information', 'ecosoap'),
                'default' => '',
            ),
            array(
                'id' => 'product_shipping_title',
                'type' => 'text',
                'title' => esc_html__('Shipping Title', 'ecosoap'),
                'default' => 'Shipping Information',
            ),
            array(
                'id' => 'product_shipping_info',
                'type' => 'editor',
                'title' => esc_html__('Shipping Information', 'ecosoap'),
                'default' => '',
            ),
            array(
                'id' => 'product_composition_title',
                'type' => 'text',
                'title' => esc_html__('Composition Title', 'ecosoap'),
                'default' => 'Composition and care',
            ),
            array(
                'id' => 'product_composition_info',
                'type' => 'editor',
                'title' => esc_html__('Composition Information', 'ecosoap'),
                'default' => '',
            ),

            array(
                'id' => 'show_product_sticky_add_to_cart',
                'type' => 'switch',
                'title' => esc_html__('Show Bottom Sticky Add To Cart', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_meta',
                'type' => 'switch',
                'title' => esc_html__('Show Product Meta', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_social_share',
                'type' => 'switch',
                'title' => esc_html__('Show Social Share', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_review_tab',
                'type' => 'switch',
                'title' => esc_html__('Show Product Review Tab', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'hidden_product_additional_information_tab',
                'type' => 'switch',
                'title' => esc_html__('Hidden Product Additional Information Tab', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_countdown_timer',
                'type' => 'switch',
                'title' => esc_html__('Show Product CountDown Timer', 'ecosoap'),
                'subtitle' => esc_html__('For only product deal', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'number_product_thumbs',
                'title' => esc_html__('Number Thumbnails Per Row', 'ecosoap'),
                'default' => 4,
                'min' => '1',
                'step' => '1',
                'max' => '8',
                'type' => 'slider',
            ),
            array(
                'id' => 'product_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'product_single_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Single Product Sidebar Layout', 'ecosoap'),
                'subtitle' => esc_html__('Select the layout you want to apply on your Single Product Page.', 'ecosoap'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Only', 'ecosoap'),
                        'alt' => esc_html__('Main Only', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'ecosoap'),
                        'alt' => esc_html__('Left - Main Sidebar', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'ecosoap'),
                        'alt' => esc_html__('Main - Right Sidebar', 'ecosoap'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main'
            ),
            array(
                'id' => 'product_single_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'ecosoap'),
                'default' => false
            ),
            array(
                'id' => 'product_single_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Left Sidebar', 'ecosoap'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'ecosoap'),
                'options' => $sidebars
            ),
            array(
                'id' => 'product_single_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Right Sidebar', 'ecosoap'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'ecosoap'),
                'options' => $sidebars
            ),

            array(
                'id' => 'product_block_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Product Block Setting', 'ecosoap').'</h3>',
            ),
            array(
                'id' => 'show_product_releated',
                'type' => 'switch',
                'title' => esc_html__('Show Products Releated', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'releated_product_columns',
                'type' => 'select',
                'title' => esc_html__('Releated Products Columns', 'ecosoap'),
                'options' => $columns,
                'default' => 4,
                'required' => array('show_product_releated', '=', true)
            ),

            array(
                'id' => 'show_product_upsells',
                'type' => 'switch',
                'title' => esc_html__('Show Products upsells', 'ecosoap'),
                'default' => 1
            ),
            array(
                'id' => 'upsells_product_columns',
                'type' => 'select',
                'title' => esc_html__('Upsells Products Columns', 'ecosoap'),
                'options' => $columns,
                'default' => 4,
                'required' => array('show_product_upsells', '=', true)
            ),
        )
    );
    
    return $sections;
}
add_filter( 'ecosoap_redux_framwork_configs', 'ecosoap_woo_redux_config', 10, 3 );