<?php

if ( !function_exists( 'ecosoap_product_metaboxes' ) ) {
	function ecosoap_product_metaboxes(array $metaboxes) {
		$prefix = 'goal_product_';
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'ecosoap' )), ecosoap_get_header_layouts() );
	    $fields = array(
            array(
                'id' => $prefix.'header_type',
                'type' => 'select',
                'name' => esc_html__('Header Layout Type', 'ecosoap'),
                'options' => $headers
            ),
	    	array(
                'id' => $prefix.'layout_type',
                'type' => 'select',
                'name' => esc_html__('Layout Type', 'ecosoap'),
                'options' => array(
                    '' => esc_html__('Global Settings', 'ecosoap'),
                    'v1' => esc_html__('Layout 1', 'ecosoap'),
                    'v2' => esc_html__('Layout 2', 'ecosoap'),
                    'v3' => esc_html__('Layout 3', 'ecosoap'),
                    'v4' => esc_html__('Layout 4', 'ecosoap'),
                    'v5' => esc_html__('Layout 5', 'ecosoap'),
                    'v6' => esc_html__('Layout 6', 'ecosoap'),
                    'v7' => esc_html__('Layout 7', 'ecosoap'),
                )
            ),
            array(
                'id' => $prefix.'bg_color',
                'type' => 'colorpicker',
                'name' => esc_html__('Background Color', 'ecosoap'),
                'description' => esc_html__('For Layout 2 ', 'ecosoap'),
            ),
	    	array(
  				'name' => esc_html__( 'Review Video', 'ecosoap' ),
  				'id'   => $prefix.'review_video',
  				'type' => 'text',
  				'description' => esc_html__( 'You can enter a video youtube or vimeo', 'ecosoap' ),
  			),
        array(
          'name' => esc_html__( 'Features', 'ecosoap' ),
          'id'   => $prefix.'features',
          'type' => 'wysiwyg'
        ),
    	);
		
		// if ( ecosoap_is_sizeguides_activated() ) {
		// 	$fields[] = array(
  //               'id' => $prefix.'sizeguides_enable',
  //               'type' => 'select',
  //               'name' => esc_html__('Size Guides Enable', 'ecosoap'),
  //               'options' => array(
  //                   '' => esc_html__('Global Settings', 'ecosoap'),
  //                   'enable' => esc_html__('Enable', 'ecosoap'),
  //                   'disable' => esc_html__('Disable', 'ecosoap'),
  //               )
  //           );
		// }

	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'More Information', 'ecosoap' ),
			'object_types'              => array( 'product' ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'ecosoap_product_metaboxes' );
