jQuery(document).ready(function($){
	"use strict";
	var ecosoap_upload;
	var ecosoap_selector;

	function ecosoap_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		ecosoap_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( ecosoap_upload ) {
			ecosoap_upload.open();
			return;
		} else {
			// Create the media frame.
			ecosoap_upload = wp.media.frames.ecosoap_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			ecosoap_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = ecosoap_upload.state().get('selection').first();

				ecosoap_upload.close();
				ecosoap_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					ecosoap_selector.find('.ecosoap_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		ecosoap_upload.open();
	}

	function ecosoap_remove_file(selector) {
		selector.find('.ecosoap_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.ecosoap_upload_image_action .remove-image', function(event) {
		ecosoap_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.ecosoap_upload_image_action .add-image', function(event) {
		ecosoap_add_file(event, $(this).parent().parent());
	});

});