<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Ecosoap_Elementor_Tabs extends Widget_Base {

    public function get_name() {
        return 'ecosoap_tabs';
    }

    public function get_title() {
        return esc_html__( 'Goal Tabs', 'ecosoap' );
    }

    public function get_icon() {
        return 'eicon-tabs';
    }

    public function get_categories() {
        return [ 'ecosoap-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Tabs', 'ecosoap' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $tabs = new Repeater();

        $tabs->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'ecosoap' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $tabs->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'ecosoap' ),
                'type' => Controls_Manager::ICON,
                'default' => '',
            ]
        );

        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();

        if ( empty( $templates ) ) {

            $this->add_control(
                'no_templates',
                array(
                    'label' => false,
                    'type'  => Controls_Manager::RAW_HTML,
                    'raw'   => $this->empty_templates_message(),
                )
            );

            return;
        }

        $options = [
            '0' => '— ' . esc_html__( 'Select', 'ecosoap' ) . ' —',
        ];

        $types = [];

        foreach ( $templates as $template ) {
            $options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            $types[ $template['template_id'] ] = $template['type'];
        }

        $tabs->add_control(
            'content_type',
            [
                'label'       => esc_html__( 'Content Type', 'ecosoap' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'template',
                'options'     => [
                    'template' => esc_html__( 'Template', 'ecosoap' ),
                    'editor'   => esc_html__( 'Editor', 'ecosoap' ),
                ],
                'label_block' => 'true',
            ]
        );

        $tabs->add_control(
            'item_template_id',
            [
                'label'       => esc_html__( 'Choose Template', 'ecosoap' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => '0',
                'options'     => $options,
                'types'       => $types,
                'label_block' => 'true',
                'condition'   => [
                    'content_type' => 'template',
                ]
            ]
        );

        $tabs->add_control(
            'content',
            [
                'label'      => esc_html__( 'Content', 'ecosoap' ),
                'type'       => Controls_Manager::WYSIWYG,
                'default'    => esc_html__( 'Tab Item Content', 'ecosoap' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition'   => [
                    'content_type' => 'editor',
                ]
            ]
        );


        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'ecosoap' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Enter title here' , 'ecosoap' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Tabs', 'ecosoap' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $tabs->get_controls(),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'ecosoap'),
                    'style2' => esc_html__('Style 2', 'ecosoap'),
                    
                ),
                'default' => 'style1'
            ]
        );

        $this->add_control(
            'tab_type',
            [
                'label' => esc_html__( 'Position Tab', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left', 'ecosoap'),
                    'right' => esc_html__('Right', 'ecosoap'),
                    'center' => esc_html__('Center', 'ecosoap'),
                ),
                'default' => 'right'
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'ecosoap' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'ecosoap' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Widget Style', 'ecosoap' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'widget_title_color',
            [
                'label' => esc_html__( 'Widget Title Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-tabs .widget-title h3' => 'color: {{VALUE}};',
                   
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Widget Title Typography', 'ecosoap' ),
                'name' => 'widget_title_typography',
                'selector' => '{{WRAPPER}} .widget-tabs .widget-title h3',
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_tabs_style',
            [
                'label' => esc_html__( 'Tabs Style', 'ecosoap' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tab_color',
            [
                'label' => esc_html__( 'Tab Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .nav-tabs > li > a' => 'color: {{VALUE}};',
                    
                    
                ],
            ]
        );

        $this->add_control(
            'tab_hover_color',
            [
                'label' => esc_html__( 'Tab Hover/Active Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .nav-tabs > li.active > a, 
                    {{WRAPPER}} .nav-tabs > li.active > a:hover, 
                    {{WRAPPER}} .nav-tabs > li.active > a:focus, 
                    {{WRAPPER}} .nav-tabs > li > a:hover, 
                    {{WRAPPER}} .nav-tabs > li > a:focus' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'bg_tab_color',
            [
                'label' => esc_html__( 'Background Tab Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li > a' => 'background-color: {{VALUE}};',
                    
                ],
            ]
        );

        $this->add_control(
            'bg_tab_hover_color',
            [
                'label' => esc_html__( 'Background Tab Hover/Active Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a' => 'background-color: {{VALUE}};', 
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a:hover'  => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a:focus'  => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a'  => 'background-color: {{VALUE}};', 
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a:hover' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a:focus' => 'background-color: {{VALUE}};', 

                ],
            ]
        );

        $this->add_control(
            'border_tab_color',
            [
                'label' => esc_html__( 'Border Tab Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li > a' => 'border-color: {{VALUE}};', 
                ],
            ]
        );

        $this->add_control(
            'border_tab_hover_color',
            [
                'label' => esc_html__( 'Border Tab Hover Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a' => 'border-color: {{VALUE}};', 
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a:hover'  => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li.active > a:focus'  => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a'  => 'border-color: {{VALUE}};', 
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a:hover' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .widget-tabs.style1 .nav-tabs > li:hover > a:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Tab Typography', 'ecosoap' ),
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .nav-tabs > li > a',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        $_id = ecosoap_random_key();

        ?>
        <div class="widget-tabs <?php echo esc_attr($el_class.' '.$style); ?>">
            
            <div class="widget-content">
                <div class="top-info-tabs <?php echo esc_attr($tab_type); ?>">
                    <?php if ( !empty($title) ): ?>
                        <div class="widget-title">
                            <h3 class="tab-title">
                                <?php echo esc_attr( $title ); ?>
                            </h3>
                        </div>
                    <?php endif; ?>
                    <ul role="tablist" class="nav nav-tabs">
                        <?php $i = 0; foreach ($tabs as $tab) : ?>
                            <li class="<?php echo esc_attr($i == 0 ? 'active' : '');?>">
                                <a href="#tab-<?php echo esc_attr($_id);?>-<?php echo esc_attr($i); ?>" data-toggle="tab">
                                    <?php if ( !empty($tab['icon']) ) { ?>
                                        <span class="icon">
                                            <i class="<?php echo esc_attr($tab['icon']); ?>"></i>
                                        </span>
                                    <?php } ?>
                                    <?php if ( !empty($tab['title']) ) { ?>
                                        <span>
                                            <?php echo trim($tab['title']); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            </li>
                        <?php $i++; endforeach; ?>
                    </ul>
                </div>
                <div class="tab-content">

                    <?php $i = 0; foreach ($tabs as $tab) : ?>
                        <div id="tab-<?php echo esc_attr($_id);?>-<?php echo esc_attr($i); ?>" class="tab-pane fade <?php echo esc_attr($i == 0 ? 'in active' : ''); ?>">

                            <div class="tabs-inner">

                                <?php
                                $ele_obj = \Elementor\Plugin::$instance;
                                $content_html = '';
                                switch ( $tab[ 'content_type' ] ) {
                                    case 'template':

                                        if ( '0' !== $tab['item_template_id'] ) {

                                            $template_content = $ele_obj->frontend->get_builder_content_for_display( $tab['item_template_id'] );

                                            if ( ! empty( $template_content ) ) {
                                                $content_html .= $template_content;

                                                if ( Plugin::$instance->editor->is_edit_mode() ) {
                                                    $link = add_query_arg(
                                                        array(
                                                            'elementor' => '',
                                                        ),
                                                        get_permalink( $tab['item_template_id'] )
                                                    );

                                                    $content_html .= sprintf( '<div class="ecosoap__edit-cover" data-template-edit-link="%s"><i class="fa fa-pencil"></i><span>%s</span></div>', $link, esc_html__( 'Edit Template', 'ecosoap' ) );
                                                }
                                            } else {
                                                $content_html = $this->no_template_content_message();
                                            }
                                        } else {
                                            $content_html = $this->no_templates_message();
                                        }
                                    break;

                                    case 'editor':
                                        if ( !empty($tab['content']) ) {
                                            $content_html = trim( $tab['content'] );
                                        }
                                    break;
                                }
                                echo trim($content_html);
                                ?>
                                
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }

    public function no_templates_message() {
        return '<div class="no-template-message"><span>' . esc_html__( 'Template is not defined.', 'ecosoap' ) . '</span></div>';
    }

    public function no_template_content_message() {
        return '<div class="no-template-message"><span>' . esc_html__( 'The tabs are working. Please, note, that you have to add a template to the library in order to be able to display it inside the tabs.', 'ecosoap' ) . '</span></div>';
    }

    public function empty_templates_message() {
        $output = '<div id="elementor-widget-template-empty-templates">';
            $output .= '<div class="elementor-widget-template-empty-templates-icon"><i class="eicon-nerd"></i></div>';
            $output .= '<div class="elementor-widget-template-empty-templates-title">' . esc_html__( 'You Haven’t Saved Templates Yet.', 'ecosoap' ) . '</div>';
            $output .= '<div class="elementor-widget-template-empty-templates-footer">';
                $output .= esc_html__( 'What is Library?', 'ecosoap' );
                $output .= '<a class="elementor-widget-template-empty-templates-footer-url" href="https://go.elementor.com/docs-library/" target="_blank">' . esc_html__( 'Read our tutorial on using Library templates.', 'ecosoap' ) . '</a>';
            $output .= '</div>';
        $output .= '</div>';

        return $output;
    }
    
}

if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Ecosoap_Elementor_Tabs );
} else {
    Plugin::instance()->widgets_manager->register( new Ecosoap_Elementor_Tabs );
}