<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Ecosoap_Elementor_Posts extends Elementor\Widget_Base {

	public function get_name() {
        return 'ecosoap_posts';
    }

	public function get_title() {
        return esc_html__( 'Goal Posts', 'ecosoap' );
    }
    
	public function get_categories() {
        return [ 'ecosoap-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Posts', 'ecosoap' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'ecosoap' ),
            ]
        );

        $this->add_control(
            'sub_title', [
                'label' => esc_html__( 'Widget Sub Title', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'sub_text', [
                'label' => esc_html__( 'Sub Text', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::TEXTAREA
            ]
        );

        $this->add_control(
            'title_type',
            [
                'label' => esc_html__( 'Position Title', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left', 'ecosoap'),
                    'center' => esc_html__('Center', 'ecosoap'),
                ),
                'default' => 'center'
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__( 'Number', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'number',
                'description' => esc_html__( 'Number posts to display', 'ecosoap' ),
                'default' => 4
            ]
        );
        
        $this->add_control(
            'order_by',
            [
                'label' => esc_html__( 'Order by', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'ecosoap'),
                    'date' => esc_html__('Date', 'ecosoap'),
                    'ID' => esc_html__('ID', 'ecosoap'),
                    'author' => esc_html__('Author', 'ecosoap'),
                    'title' => esc_html__('Title', 'ecosoap'),
                    'modified' => esc_html__('Modified', 'ecosoap'),
                    'rand' => esc_html__('Random', 'ecosoap'),
                    'comment_count' => esc_html__('Comment count', 'ecosoap'),
                    'menu_order' => esc_html__('Menu order', 'ecosoap'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Sort order', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'ecosoap'),
                    'ASC' => esc_html__('Ascending', 'ecosoap'),
                    'DESC' => esc_html__('Descending', 'ecosoap'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'slugs',
            [
                'label' => esc_html__( 'Categories Slug', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::TEXTAREA,
                'rows' => 2,
                'default' => '',
                'placeholder' => esc_html__( 'Enter slug spearate by comma(,)', 'ecosoap' ),
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
                'condition' => [
                    'layout_type' => ['grid', 'carousel'],
                ],
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'ecosoap'),
                    'carousel' => esc_html__('Carousel', 'ecosoap'),
                    'sticky' => esc_html__('Sticky', 'ecosoap')
                ),
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'item_type',
            [
                'label' => esc_html__( 'Item Style', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid-home' => esc_html__('Grid', 'ecosoap'),
                    'list-home' => esc_html__('List', 'ecosoap'),
                ),
                'default' => 'grid'
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ecosoap' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'ecosoap' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label' => esc_html__( 'Show Nav', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'ecosoap' ),
                'label_off' => esc_html__( 'Show', 'ecosoap' ),
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show Pagination', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'ecosoap' ),
                'label_off' => esc_html__( 'Show', 'ecosoap' ),
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'ecosoap' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'ecosoap' ),
                'label_off'     => esc_html__( 'No', 'ecosoap' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'ecosoap' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'ecosoap' ),
                'label_off'     => esc_html__( 'No', 'ecosoap' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'ecosoap' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'ecosoap' ),
            ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
            'section_widget_title_style',
            [
                'label' => esc_html__( 'Widget Title Style', 'ecosoap' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-title h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color',
            [
                'label' => esc_html__( 'Sub Title Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .sub-widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_text_color',
            [
                'label' => esc_html__( 'Sub Text Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .sub-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'ecosoap' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .widget-title h3',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_style',
            [
                'label' => esc_html__( 'Post Style', 'ecosoap' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color',
            [
                'label' => esc_html__( 'Post Title Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .entry-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_title_hv_color',
            [
                'label' => esc_html__( 'Post Title Hover Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .entry-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Post Title Typography', 'ecosoap' ),
                'name' => 'post_title_typography',
                'selector' => '{{WRAPPER}} .post-layout .entry-title a',
            ]
        );

        $this->add_control(
            'post_excerpt_color',
            [
                'label' => esc_html__( 'Post Excerpt Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post .description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Post Excerpt Typography', 'ecosoap' ),
                'name' => 'post_excerpt_typography',
                'selector' => '{{WRAPPER}} .post .description',
            ]
        );

        $this->add_control(
            'post_top_info_color',
            [
                'label' => esc_html__( 'Post Top Info Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .top-info a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .post-layout .top-info span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_top_info_hv_color',
            [
                'label' => esc_html__( 'Post Top Info Hover Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .top-info a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );



        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Post Top Info Typography', 'ecosoap' ),
                'name' => 'post_top_info_typography',
                'selector' => '{{WRAPPER}} .post-layout .top-info a',
            ]
        );

        $this->add_control(
            'post_date_color',
            [
                'label' => esc_html__( 'Post Date Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_date_bg_color',
            [
                'label' => esc_html__( 'Post Date Background Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .date' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_date_border_color',
            [
                'label' => esc_html__( 'Post Date Border Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout .date' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Post Date Typography', 'ecosoap' ),
                'name' => 'post_date_typography',
                'selector' => '{{WRAPPER}} .post-layout .date',
            ]
        );


        $this->add_control(
            'post_readmore_color',
            [
                'label' => esc_html__( 'Post Read More Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-grid-v2 .top-image .readmore i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_readmore_bg_color',
            [
                'label' => esc_html__( 'Post Read More Background Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-grid-v2 .top-image .readmore' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_readmore_border_color',
            [
                'label' => esc_html__( 'Post Read More Border Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-grid-v2 .top-image .readmore' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_readmore_hv_color',
            [
                'label' => esc_html__( 'Post Read More Hover Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout:hover .readmore i' => 'color: {{VALUE}};',
                ],
            ]
        );


         $this->add_control(
            'post_readmore_bg_hv_color',
            [
                'label' => esc_html__( 'Post Read More Background Hover Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout:hover .readmore' => 'background-color: {{VALUE}};',
                ],
            ]
        );

         $this->add_control(
            'post_readmore_border_hv_color',
            [
                'label' => esc_html__( 'Post Read More Border Hover Color', 'ecosoap' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .post-layout:hover .readmore' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Post Read More Typography', 'ecosoap' ),
                'name' => 'post_readmore_typography',
                'selector' => '{{WRAPPER}} .post .readmore',
            ]
        ); 

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $number,
            'orderby' => $order_by,
            'order' => $order,
        );

        $slugs = !empty($slugs) ? array_map('trim', explode(',', $slugs)) : array();
        if ( !empty($slugs) && is_array($slugs) ) {
            $args['tax_query'][] = array(
                'taxonomy'      => 'category',
                'field'         => 'slug',
                'terms'         => $slugs,
                'operator'      => 'IN'
            );
        }

        $loop = new WP_Query($args);
        if ( $loop->have_posts() ) {
            if ( $image_size == 'custom' ) {
                
                if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
                    $thumbsize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
                } else {
                    $thumbsize = 'full';
                }
            } else {
                $thumbsize = $image_size;
            }
            set_query_var( 'thumbsize', $thumbsize );
            $rows = isset($rows) ? $rows : 1;
            $columns = !empty($columns) ? $columns : 3;
            $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 3;
            $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 2;

            $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : $columns;
            $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $slides_to_scroll;
            $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : 1;
            ?>
            <div class="widget widget-blogs widget-<?php echo esc_attr($layout_type); ?> <?php echo esc_attr($el_class); ?>">
                <div class="top-info <?php echo esc_attr(($title_type != 'center')?'flex-middle-sm':'text-center'); ?>">
                    <?php if ( !empty($title) ): ?>
                    <div class="widget-title">
                        <?php if ( !empty($sub_title) ): ?>
                            <span class="sub-widget-title">
                                <?php echo esc_attr( $sub_title ); ?>
                            </span>
                        <?php endif; ?>

                        <?php if ( !empty($title) ): ?>
                            <h3>
                                <?php echo esc_attr( $title ); ?>
                            </h3>
                        <?php endif; ?>
                       
                        <?php if ( !empty($sub_text) ): ?>
                            <p class="sub-text">
                                <?php echo esc_attr( $sub_text ); ?>
                            </p>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="widget-content">
                    
                    <?php if ( $layout_type == 'carousel' ): ?>
                        <div class="slick-carousel <?php echo esc_attr($columns < $loop->post_count?'':'hidden-dots'); ?>"
                                data-rows="<?php echo esc_attr( $rows ); ?>"
                                data-items="<?php echo esc_attr($columns); ?>"
                                data-smallmedium="<?php echo esc_attr( $columns_tablet ); ?>"
                                data-extrasmall="<?php echo esc_attr($columns_mobile); ?>"

                                data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                                data-slidestoscroll_smallmedium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                                data-slidestoscroll_extrasmall="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

                                data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>">
                            <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
                                <div class="item">
                                    <?php get_template_part( 'template-posts/loop/inner',$item_type); ?>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    <?php elseif ( $layout_type == 'sticky' ): ?>

                        <div class="layout-blog  style-sticky">
                             <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
                                <div class="post-sticky">
                                    <?php get_template_part( 'template-posts/loop/inner',$item_type); ?>
                                </div>
                            <?php endwhile; ?>
                        </div>    
                    <?php else: ?>
                        <?php $bcol = 12/$columns; ?>
                        <div class="layout-blog  style-grid">
                            <div class="row">
                                <?php
                                    $mdcol = 12/$columns;
                                    $smcol = 12/$columns_tablet;
                                    $xscol = 12/$columns_mobile;
                                    while ( $loop->have_posts() ) : $loop->the_post();
                                ?>
                                    <div class="col-md-<?php echo esc_attr($mdcol); ?> col-sm-<?php echo esc_attr($smcol); ?> col-xs-<?php echo esc_attr($xscol); ?>">
                                        <?php get_template_part( 'template-posts/loop/inner',$item_type); ?>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
            <?php
        }

    }

}

if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Ecosoap_Elementor_Posts );
} else {
    Elementor\Plugin::instance()->widgets_manager->register( new Ecosoap_Elementor_Posts );
}