<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Ecosoap_Elementor_Carousel extends Widget_Base {

	public function get_name() {
        return 'ecosoap_carousel';
    }

	public function get_title() {
        return esc_html__( 'Goal Carousel', 'ecosoap' );
    }

    public function get_icon() {
        return 'eicon-carousel';
    }

	public function get_categories() {
        return [ 'ecosoap-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Carousel', 'ecosoap' ),
                'carousel' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $carousels = new Repeater();

      

        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();

        if ( empty( $templates ) ) {

            $this->add_control(
                'no_templates',
                array(
                    'label' => false,
                    'type'  => Controls_Manager::RAW_HTML,
                    'raw'   => $this->empty_templates_message(),
                )
            );

            return;
        }

        $options = [
            '0' => '— ' . esc_html__( 'Select', 'ecosoap' ) . ' —',
        ];

        $types = [];

        foreach ( $templates as $template ) {
            $options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            $types[ $template['template_id'] ] = $template['type'];
        }

        $carousels->add_control(
            'content_type',
            [
                'label'       => esc_html__( 'Content Type', 'ecosoap' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'template',
                'options'     => [
                    'template' => esc_html__( 'Template', 'ecosoap' ),
                    'editor'   => esc_html__( 'Editor', 'ecosoap' ),
                ],
                'label_block' => 'true',
            ]
        );

        $carousels->add_control(
            'item_template_id',
            [
                'label'       => esc_html__( 'Choose Template', 'ecosoap' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => '0',
                'options'     => $options,
                'types'       => $types,
                'label_block' => 'true',
                'condition'   => [
                    'content_type' => 'template',
                ]
            ]
        );

        $carousels->add_control(
            'content',
            [
                'label'      => esc_html__( 'Content', 'ecosoap' ),
                'type'       => Controls_Manager::WYSIWYG,
                'default'    => esc_html__( 'Carousel Item Content', 'ecosoap' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition'   => [
                    'content_type' => 'editor',
                ]
            ]
        );

      

        $this->add_control(
            'carousels',
            [
                'label' => esc_html__( 'Carousel', 'ecosoap' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $carousels->get_controls(),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'ecosoap'),
                    'style1' => esc_html__('Style 1', 'ecosoap'),
                    
                ),
                'default' => ''
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 6,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ecosoap' ),
                'options' => $columns,
                'frontend_available' => true,
                'default' => 1,
            ]
        );
        
        $this->add_control(
            'show_nav',
            [
                'label' => esc_html__( 'Show Nav', 'ecosoap' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'ecosoap' ),
                'label_off' => esc_html__( 'Show', 'ecosoap' ),
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show Pagination', 'ecosoap' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'ecosoap' ),
                'label_off' => esc_html__( 'Show', 'ecosoap' ),
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'ecosoap' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'ecosoap' ),
                'label_off'     => esc_html__( 'No', 'ecosoap' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

         $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'ecosoap' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'ecosoap' ),
                'label_off'     => esc_html__( 'No', 'ecosoap' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'navigation_position',
            [
                'label' => esc_html__( 'Navigation Position Horizontal', 'ecosoap' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Normal', 'ecosoap'),
                    'arrow-full' => esc_html__('Outside', 'ecosoap'),
                    'arrow-small' => esc_html__('Inside', 'ecosoap'),
                ),
                'default' => '',
               
            ]
        ); 

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'ecosoap' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'ecosoap' ),
            ]
        );

        $this->add_responsive_control(
            'carousels_align',
            [
                'label' => esc_html__( 'Alignment', 'ecosoap' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'ecosoap' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'ecosoap' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'ecosoap' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'ecosoap' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .widget-carousel' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_carousels_style',
            [
                'label' => esc_html__( 'Carousels Style', 'ecosoap' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'carousel_color',
            [
                'label' => esc_html__( 'Carousel Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .carousel-inner' => 'color: {{VALUE}};',
                    
                    
                ],
            ]
        );

        $this->add_control(
            'carousel_span_color',
            [
                'label' => esc_html__( 'Carousel Span Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .carousel-inner span' => 'color: {{VALUE}};',
                    
                    
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Carousel Typography', 'ecosoap' ),
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .carousel-inner',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'dots_style',
            [
                'label' => esc_html__( 'Dots Style', 'ecosoap' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'dots_bg_color',
            [
                'label' => esc_html__( 'Dots Background Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .slick-carousel .slick-dots li button ' => 'background-color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'dots_bg_hv_color',
            [
                'label' => esc_html__( 'Dots Background Hover Color', 'ecosoap' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .slick-carousel .slick-dots li.slick-active ' => 'border-color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($carousels) ) {
            $columns = !empty($columns) ? $columns : 3;
            $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 3;
            $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;

            $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : $columns;
            $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $slides_to_scroll;
            $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : 1;

            ?>
            <div class="widget-carousel carousel-templates <?php echo esc_attr($el_class); ?>">
                <div class="slick-carousel <?php echo esc_attr($navigation_position); ?>"
                    data-items="<?php echo esc_attr($columns); ?>"
                        data-smallmedium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-extrasmall="<?php echo esc_attr($columns_mobile); ?>"
                        data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" 
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" 
                        data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>"
                        data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>"
                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>" 
                        data-slidestoscroll_smallmedium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>" 
                        data-slidestoscroll_extrasmall="<?php echo esc_attr($slides_to_scroll_mobile); ?>">
                    

                     <?php foreach ($carousels as $carousel) { ?>
                            
                        <div class="carousel-inner">

                                <?php
                                $ele_obj = \Elementor\Plugin::$instance;
                                $content_html = '';
                                switch ( $carousel[ 'content_type' ] ) {
                                    case 'template':

                                        if ( '0' !== $carousel['item_template_id'] ) {

                                            $template_content = $ele_obj->frontend->get_builder_content_for_display( $carousel['item_template_id'] );

                                            if ( ! empty( $template_content ) ) {
                                                $content_html .= $template_content;

                                                if ( Plugin::$instance->editor->is_edit_mode() ) {
                                                    $link = add_query_arg(
                                                        array(
                                                            'elementor' => '',
                                                        ),
                                                        get_permalink( $carousel['item_template_id'] )
                                                    );

                                                    // $content_html .= sprintf( '<div class="ecosoap__edit-cover" data-template-edit-link="%s"><i class="fa fa-pencil"></i><span>%s</span></div>', $link, esc_html__( 'Edit Template', 'ecosoap' ) );
                                                }
                                            } else {
                                                $content_html = $this->no_template_content_message();
                                            }
                                        } else {
                                            $content_html = $this->no_templates_message();
                                        }
                                    break;

                                    case 'editor':
                                        if ( !empty($carousel['content']) ) {
                                            $content_html = trim( $carousel['content'] );
                                        }
                                    break;
                                }
                                echo trim($content_html);
                                ?>
                                
                            </div>
                        <?php } ?>
                </div>
            </div>
            <?php
        }
    }

}
if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Ecosoap_Elementor_Carousel );
} else {
    Plugin::instance()->widgets_manager->register( new Ecosoap_Elementor_Carousel );
}